 #include <iostream>
#include <pthread.h>

#define _MULTI_THREADED
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include "../Communication/CommunicationReceiver.h" 
#include "../Configuration/ConfigurationServer.h"
#include "SimulationEngineController.h"
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>

#include <arpa/inet.h>

#include <stdio.h>
#include "../XmlParser/xmlParser.h"

#include <list.h>
using namespace std;
using namespace Communication;
using namespace Configuration;
using namespace SimulationEngine;

static SimulationEngineController *simulation;
static CommunicationReceiver  *communicationthread;

void freeResources(int signum)
{
	simulation->FreeResources();
	communicationthread->FreeResources();
	delete communicationthread;

	cout<<"Execution Finalized"<<endl;
	exit(0);
}


int main(int argc, char*argv[]) {
	signal(SIGTERM, freeResources);
	signal(SIGINT, freeResources);
	signal(SIGSEGV, freeResources);
	signal(SIGTSTP, freeResources);
	signal(SIGABRT, freeResources);
	pthread_t thread;
	communicationthread = new CommunicationReceiver();
	pthread_create(&thread, NULL, ThreadStartup, communicationthread);
    simulation = SimulationEngineController::GetInstance();
    bool gui=false;
    if (argc>1 && strcmp(argv[1],"-gui")==0)
    	gui=true;
    simulation->RunEngine(gui);
    freeResources(0);
	return 0;
}
